<?php


// donne lien : reçoit une adresse de fichier et une taille, verifie si une vignette a cette taille existe et produit une version de cette image. le cas échaant renvoie cette adresse
// exemple : echo donne_lien("image.jpg",600,600,true);
// "image.jpg" : le lien relatif de l'image
// 600,600 : taille en largeur et hauteur de l'image
// true : l'image fera cette taille, obtenue en coupant dans l'image mais en exploitant le maximum de sa surface
// false : coupe en gardant les proportions de l'image mais en exploitant au mieux la taille donnée.

function affiche_image($file,$l_vignette=600,$h_vignette=600,$crop=true, $enlarge=false){
    // creer le dossier pour les images petites
    $dossier_vignettes="vignettes/";

    if(!is_dir($dossier_vignettes)){
        mkdir($dossier_vignettes, 0777, true);
    }
    if(!is_file($file)){ $file="img-default/default.jpg"; }
    $ext_image=array('jpg','png','gif');
    $ext=strtolower(substr(strrchr($file,"."),1));
    if($crop){ $c="c"; } else { $c="p"; }

    $add="_".$l_vignette."_".$h_vignette."_".$c;
    $nom=fichier_seul($file);
    $full_nom=$dossier_vignettes.$nom.$add.".".$ext;

    // - - - image : traitement des icones
    if(in_array($ext,$ext_image)){
        // charger l'image brute
        // vérifier que l'image existe
        // sinon la créer
        if (!file_exists($full_nom)) {
            if(image_resize($file, $full_nom, $l_vignette, $h_vignette, $crop)){
                return $full_nom."?".filectime($full_nom);
            } else {
                return $file;
            }
        } else {
            return $full_nom."?".filectime($full_nom);   
        }

    } else {
        return "img_sys/error.jpg";   
    }

}
// a partir d'un lien relatif, renvoie le nom du fichier seul
// exemple : "image/monimage.gif" devient "monimage.gif"
function fichier_seul($file){
    $file = preg_replace('/.*\//i', '', $file);
    return $file;	
}

// image_resize : crée une image au format demandé avec crop ou proportion
// $src : nom de l'image (lien relatif)
// $dst : nom de l'image créée (lien relatif)
// $width : la largeur demandée
// $height : la hauteur demandée
// $crop : provoque le recadrage (1) ou la réduction en proportion (0)
function image_resize($src, $dst, $width=500, $height=400, $crop=false, $enlarge=false){
    ini_set('memory_limit', '256M');
    if(!list($w, $h) = getimagesize($src)) {
        echo "image does not exists";
        return false;
    }

    $type = strtolower(substr(strrchr($src,"."),1));
    if($type == 'jpeg') $type = 'jpg';
    switch($type){
        case 'gif': $img = imagecreatefromgif($src); break;
        case 'jpg': $img = imagecreatefromjpeg($src); break;
        case 'png': $img = imagecreatefrompng($src); break;
        default : echo "image does not exists"; return false;
    }



    // resize
    if($crop){
        if($w < $width or $h < $height){ 
            // enlarge
            if($enlarge){

            } else {
                return false;
            }
            
        };

        $ratio = max($width/$w, $height/$h);
        $y= ($h - $height / $ratio) /2;
        $x = ($w - $width / $ratio) / 2;
        $h = $height / $ratio;
        $w = $width / $ratio;

    } else {

        if($w < $width and $h < $height) {
            // enlarge
            if($enlarge){

            } else {
                return false;
            }
        }

        $ratio = min($width/$w, $height/$h);
        $width = $w * $ratio;
        $height = $h * $ratio;
        $x = 0;
        $y = 0;
    }

    $new = imagecreatetruecolor($width, $height);

    // preserve transparency
    if($type == "gif" or $type == "png"){
        imagecolortransparent($new, imagecolorallocatealpha($new, 0, 0, 0, 127));
        imagealphablending($new, false);
        imagesavealpha($new, true);
    }
    imagecopyresampled($new, $img, 0, 0, $x, $y, $width, $height, $w, $h);
    switch($type){
        case 'gif': imagegif($new, $dst); break;
        case 'jpg': imagejpeg($new, $dst); break;
        case 'png': imagepng($new, $dst); break;
    }
    return true;
}

?>