<?php
if(isset($_POST['go'])){
    include("assets/functions.php");
    $largeur=(int) $_POST['largeur'];
    $hauteur=(int) $_POST['hauteur'];
    
    $option=""; // options de l'export
    if(isset($_POST['crop'])){
        $crop=true;
        $option.="_crop";
    } else {
        $crop=false;
    }
    if(isset($_POST['enlarge'])){
        $allow_enlarge=true;
        $option.="_enlarge";
    } else {
        $allow_enlarge=false;
    }
    /* lister les fichiers */
    $fichiers=glob("upload/*.{jpg,png,gif,JPG,jpeg,GIF,PNG}",GLOB_BRACE);
    $message="<h3>Fabrication des vignettes de $largeur pixels X $hauteur pixels</h3>";
    $message.="<p>".count($fichiers)." fichiers à traiter</p>";

    // éviter les erreurs de script : les valeurs doivent exister
    $okay=true;
    if($largeur < 10 || $hauteur < 10){
        $message.= "Valeurs en largeur ou hauteur insuffisantes : au moins 10 px<br>Aucune image processée.";
        $okay=false;
    }

    if($okay){
        // créer le dossier pour les vignettes
        $dossier_vignettes="vignettes_".$largeur."_".$hauteur.$option."/";
        if(!is_dir($dossier_vignettes)){
            mkdir($dossier_vignettes, 0777, true);
        }
        foreach($fichiers as $fichier){
            if(image_resize($fichier, $dossier_vignettes.fichier_seul($fichier), $largeur, $hauteur, $crop,$allow_enlarge)){
                $message.="<div class='texte_tiny'>Image '$fichier' processée</div>";
            } else {
                $message.="<div class='texte_tiny'>Image '$fichier' ignorée (probablement trop petite).</div>";
            }
            
        }
        $message.="<p>- Process terminé -</p>";
    }
} 
?>
<!DOCTYPE html>
<html lang="fr">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Un outil de génération d'images recadrées</title>
        <link rel="stylesheet" href="assets/stephgrids.css">
        <link rel="stylesheet" href="assets/style.css">
        <script src="assets/jquery-3.5.1.min.js"></script>

    </head>

    <body>
        <div class="wrapper">
            <header class="colonne full nobottom">
                <h1>Resizer php</h1>
                <h2>Un formulaire pour fabriquer des vignettes à taille choisie</h2>
                <?php
                if(isset($message)){
                    echo "<div class='retour'>$message</div>";
                }
                ?>
            </header>
            <section class="form colonne full">
                <form method="post" action="index.php">
                    <img src="assets/hourglass.png" id="wait-icon">
                    <p>
                        Placez les dossier dans le dossier <b>"upload"</b> à côté de ce script puis choisissez la taille de la vignette et le crop (découpe dans les images pour leur donner le format exact). 
                    </p>
                    <p>
                        <label>Taille en largeur (en pixels)</label>
                        <input type="text" name="largeur" value="400">
                    </p>
                    <p>
                        <label>Taille en hauteur (en pixels)</label>
                        <input type="text" name="hauteur" value="400">
                    </p>
                    <p>
                    
                    </p>
                    
                    <p>
                        <label>Recadrage des images</label>
                        <input type="checkbox" name="crop" checked="checked" value="crop"><br>
                        <span class="texte_tiny">Si la case l'est pas cochée, les images ne sont pas recoupées mais entrent au maximum du rectangle dont les dimensions sont spécifiées ci-dessus</span>
                    </p>
                    <p>
                        <label>Agrandir les images trop petites</label>
                        <input type="checkbox" name="enlarge" value="crop"><br>
                        <span class="texte_tiny">Si la case est cochée, les images trop petites seront agrandies, ce qui peut être assez laid.<br>
                        Si la case n'est pas cochée, les images plus petites que la taille spécifiée ne seront pas traitées.</span>
                    </p>
                    <p>
                        <input type="submit" name="go" value="C'est parti">
                    </p>
                </form>
            </section>
        </div>
    </body>
    <script>
        $("form" ).submit(function(event){
            $(this).addClass("wait");
            //event.preventDefault();
        });
    </script>
</html>
