 // script pour la création de player son
            // s'attend à une structure comme
            // <div class="lecteur"><audio controls><source="monmp3.mp3" type="audio/mp3"></audio></div>
            var audios=document.querySelectorAll(".lecteur");
            var controldiv ="<div class='playpause'><button class='play'>Play</button><button class='pause'>Pause</button></div><div class='playinfo'><div class='playtime'><span class='elapsed'>00:00</span> / <span class='total'>00:00</span></div><div class='timeline'><div class='bar-played'></div></div></div>";

            audios.forEach(function(player){
                var drag=false;
                var add=document.createElement( 'div' );
                add.innerHTML=controldiv;
                player.appendChild(add);

                var son=player.querySelector("audio");
                var bplay=player.querySelector(".play");
                var bpause=player.querySelector(".pause");
                var telapsed=player.querySelector(".elapsed");
                var ttotal=player.querySelector(".total");
                var ttimeline=player.querySelector(".timeline");

                // on cache la barre de controle et le bouton pause
                son.removeAttribute("controls");
                bpause.style.display="none";

                // gestion des bouton play et pause
                bplay.onclick = function(){
                    son.play();
                    bplay.style.display="none";
                    bpause.style.display="block";
                };
                bpause.onclick = function(){
                    son.pause();
                    bpause.style.display="none";
                    bplay.style.display="block";
                };

                // récupérer les metadatas
                son.addEventListener('loadedmetadata',function(){
                    ttotal.innerHTML=formate_temps(son.duration);
                },false);

                // montrer les infos pendant la lecture
                son.addEventListener("timeupdate", function() {
                    // ligne du temps
                    var pc=(son.currentTime/son.duration)*100;
                    ttimeline.querySelector(".bar-played").style.width= pc+"%";
                    telapsed.innerHTML=formate_temps(son.currentTime);
                }, false);

                // gestion du clic et drag sur la barre de temps
                ttimeline.onclick = function(e){
                    var lt=this.clientWidth;
                    var x = e.pageX - this.offsetLeft;
                    son.currentTime=son.duration*(x/lt);
                };
                ttimeline.onmousedown=function() {
                    drag=true;
                };
                ttimeline.onmouseup=function(){
                    drag=false;
                };
                ttimeline.onmousemove=function(e){
                    if(drag){
                        var lt=$(this).innerWidth();
                        var x = e.pageX - this.offsetLeft;
                        son.currentTime=son.duration*(x/lt);
                    }
                };
            });

            // Transformer la durée (en secondes brutes, 221 par ex)
            // vers une structure minutes/secondes (3:41 par ex)
            function formate_temps(temps){
                s = parseInt(temps % 60);
                m = Math.floor( temps / 60 ) % 60;
                s = s < 10 ? "0"+s : s;
                m = m < 10 ? "0"+m : m;
                return m+":"+s;
            }