<!-- intégration du javascript, seulement utilisé dans cette page -->
<script src="<?php echo get_template_directory_uri(); ?>/assets/lazyload.min.js"></script>

<main class="container-fluid">
    <?php
    // on garde la requete par defaut
    $temp_query = $wp_query;
    $args = array( 
        'post_type'   => array( 'post' ),
        //'category_name' => 'identite-graphique,illustration',
        'posts_per_page' => '10',
        'order_by' => 'ASC',
    );
    query_posts($args);
    if(have_posts()) : ?>
    <div id="main" class="py-4">
        <?php while(have_posts()) : the_post(); ?>
        <div class="lazy-conteneur">
            <a class="lazy-link" href="<?php the_permalink(); ?>">
                <img
                     class="lazy"
                     alt="attente"
                     data-src="<?php echo get_the_post_thumbnail_url($post_id, 'vert-rectangle'); ?>"
                     />
            </a>
        </div>
        <?php endwhile; ?>
    </div>
    <?php endif; ?>
</main>
<?php 
/* retrouver la query de base */
$wp_query = $temp_query; ?>

<style>
    .lazy-conteneur {
        margin-bottom:-60px; /* zone potentiellement recouvrable des images */
        position:relative;
    }

    .lazy-conteneur:last-child {
        margin-bottom:2em;
    }

    .lazy-link {
        display: block;
        position:relative;
    }

    img {
        display: block;
        border: 0;
        width: 100%;
        height: auto;
        border:1px solid #bbb;
        padding:1px;
        background-color:#fff;
        border-radius:2px;
        position:relative;
    }
    img.lazy {
        opacity: 0;
        top:80px;
        transition: all 1s;
    }

    img:not([src]) {
        visibility: hidden;
    }
    img.loaded.moveit, img.error {
        opacity: 1;
        top:0px;
    }

    /* decrire les différentes largeurs */
    .largeur25 {
        width:25%;
    }
    .largeur30 {
        width:30%;
    }
    .largeur35 {
        width:35%;
    }
    .largeur40 {
        width:40%;
    }
    @media (max-width: 768px){
        .lazy-link {
            margin-left:2% !important;
        }
        .lazy-conteneur {
            margin-bottom: 1em;
        }
        .largeur25, .largeur30, .largeur35, .largeur40 {
            width:96%;   
        }
    }
</style>
<script>

    var blocs=document.querySelectorAll("#main .lazy-conteneur")

    /* reperer le scroll et faire apparaitre les imges */
    window.addEventListener('scroll', function (event) {
        blocs.forEach(function(elem){
            if (isInViewport(elem)) {
                var blocimage=elem.querySelector('.lazy')
                if(!blocimage.classList.contains('moveit')){
                    blocimage.classList.add("moveit")
                }
            }
        })
    }, false);

    /* lazyload: charger les images qui vont apparaitre */
    (function () {
        var ll = new LazyLoad({
            threshold: 100,
            // Assign the callbacks defined above
            callback_loaded: function(elem){
                if (isInViewport(elem)) {
                    elem.classList.add("moveit")
                }
            },
        });
    })();

    /* fonction qui detecte l'apparition dans le viewport */
    var isInViewport = function (elem) {
        var distance = elem.getBoundingClientRect();
        return (
            distance.top >= 0 &&
            distance.bottom <= (window.innerHeight || document.documentElement.clientHeight) 
        );
    };

    /*
    placement aléatoire horizontale des images
    */
    var marge="2" // marge a respecter à gauche et droite
    var largeurs=["25","30","35","40"] // en pourcent


    blocs.forEach(function(elem){
        var blocimage=elem.querySelector('.lazy-link')

        var quelle_largeur=Math.floor(Math.random() * largeurs.length)
        console.log("largeur n°"+quelle_largeur)

        blocimage.classList.add("largeur"+largeurs[quelle_largeur])

        var placement=Math.random() * (100 - marge-marge-largeurs[quelle_largeur])
        blocimage.style.marginLeft=placement+"%"
    })
</script>