// detruire un dessin
import processing.pdf.*;
boolean saveOneFrame = false;

String image_source="flaubert.jpg";

ArrayList<pixel> pix;
PImage im;
float nbx=120.0;
float nby=120.0;
int zone_influence=15;
boolean show_stroke=false;

void setup() {
  im=loadImage(image_source);
  size(634,800);
  pix=new ArrayList<pixel>();
  for (float px=0;px<width;px+=width/nbx) {
    for (float py=0;py<height;py+=height/nby) {
      color c=im.get(int(px), int(py));
      if (brightness(c) < 250) {
        pix.add(new pixel(px, py, c, width/nbx, height/nby));
      }
    }
  }
  rectMode(CENTER);
}

void draw() {
  if (saveOneFrame == true) {
    beginRecord(PDF, "Line.pdf");
  }
  background(255);
  noStroke();
  for (int i = 0; i <pix.size(); i++) {
    pixel cf=pix.get(i);
    cf.affiche();
    cf.choc();
  }

  stroke(255, 0, 0);
  noFill();
  if (saveOneFrame == true) {
    endRecord();
    saveOneFrame = false;
  } 
  else {
    ellipse(mouseX, mouseY, zone_influence*2, zone_influence*2);
  }
}

void keyPressed() {
  if (key==' ') {
    if (show_stroke==false) {
      show_stroke=true;
    } 
    else {
      show_stroke=false;
    }
  }
  
  if(key == 's'){
    saveOneFrame = true;
  }

  if (key=='x') {
    for (int i = 0; i <pix.size(); i++) {
      pixel cf=pix.get(i);
      cf.position.x=cf.pox;
      cf.position.y=cf.poy;
    }
  }
}

class pixel {
  float tx, ty;
  float pox, poy;
  PVector position, deplacement;
  color c;

  pixel(float px, float py, color co, float tx, float ty) {
    pox=px;
    poy=py;
    position=new PVector(px, py);
    deplacement=new PVector(0, 0);
    c=co;
    this.tx=tx;
    this.ty=ty;
  }

  void affiche() {
    if (show_stroke==true) {
      float dx=mouseX-(position.x);
      float dy=mouseY-(position.y);
      stroke(map(dist(position.x, position.y, pox, poy), 0, width/2, 0, 255));
      line(pox, poy, position.x, position.y);
      noStroke();
    }
    fill(c);
    rect(position.x, position.y, tx, ty);
    // reduire la vitesse
    deplacement.div(1.1);
    position.x+=deplacement.x;
    position.y+=deplacement.y;
  }

  void choc() {
    float dx=mouseX-(position.x);
    float dy=mouseY-(position.y);
    if (abs(dx)<zone_influence && abs(dy)<zone_influence) {
      float d=map(dist(position.x, position.y, mouseX, mouseY), 0, 100, 0.1, 1.1);
      deplacement.x=-dx*d;
      deplacement.y=-dy*d;
    }
  }
}