<?php 

// template pour les catégories et les archives

get_header(); 
?>

<main class="container px-3 px-md-5 my-5">
    <h2 class="mb-4"><?php single_cat_title(); ?></h2>
    <div class="row mb-4">
        <?php if(have_posts()) : ?><?php while(have_posts()) : the_post(); ?>
        <article class="mb-3 mb-md-4">
            <div class="row align-items-end">
                <div class="col-12 col-sm-6">
                    <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>">
                    <?php the_post_thumbnail('rectangle', array( 'class' => 'mb-3 w-100' )); ?>
                    </a>
                </div>
                <div class="col-12 col-sm-6 col-lg-3 decoration-hover">
                    <h2 class="mb-3">
                        <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>"><?php the_title(); ?></a>
                    </h2>

                    <div class="texte-petit"><b>Catégorie:</b> <?php the_category(', '); ?></div>
                    <div class="texte-petit"><b>Date:</b> <?php the_date('j F Y'); ?></div>
                    <div class="texte-moyen">
                        <?php the_excerpt(); ?>
                    </div>
                </div>
            </div>
        </article>
        <div class="mb-4 d-md-none"><hr class="w-50 mx-auto"></div>
        <?php endwhile; ?>
        <?php endif; ?>
    </div>

    <!-- lien vers page precedente et suivante -->
    <div class="navigation">
        <?php posts_nav_link(' - ','page suivante','page pr&eacute;c&eacute;dente'); ?>
    </div>
</main>

<?php get_footer(); ?>