<!DOCTYPE html>
<html lang="fr">
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">

        <title><?php bloginfo('name'); ?></title>

        <!-- css diverses -->
        <link href="<?php echo get_template_directory_uri(); ?>/assets/bootstrap/css/bootstrap.css" rel="stylesheet">
        <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/assets/rubik-webfontkit/stylesheet.css">
        <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/style.css">

        <!-- jeu d'icones de bootstrap : https://icons.getbootstrap.com/ -->
        <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/assets/bootstrap/icons/bootstrap-icons.css">

        <!-- Include all compiled plugins (below), or include individual files as needed -->
        <script src="<?php echo get_template_directory_uri(); ?>/assets/bootstrap/js/bootstrap.min.js"></script>

        <?php wp_head(); ?>
    </head>
    <body <?php body_class(); ?>>
        <div class="container-fluid px-3 px-md-5 pt-2 pt-md-5 mb-0">
            <div class="row flex-nowrap">
                <h1 class="col-10 col-md-9 col-lg-8 titre-enorme text-primary"><a class="text-decoration-none" href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php bloginfo('name'); ?></a></h1>
                <div class="col ms-auto text-end">
                    <button class="navbar-toggler d-md-none" type="button" data-bs-toggle="collapse" data-bs-target=".navbar-collapse" aria-controls="" aria-expanded="false" aria-label="Toggle navigation">
                        <i class="bi bi-list"></i>
                    </button>
                </div>
            </div>
        </div>


        <nav class="navbar navbar-expand-md navbar-light mb-5 mb-md-0">
            <div class="container-fluid px-3 px-md-5 pt-2 pt-md-5 mb-0 ">
                <?php
                // transformer le menu en menu prêt pour bootstrap
                wp_nav_menu(array(
                    'theme_location'    => 'menu-principal',
                    'container'       => 'div',
                    'container_id'    => '',
                    'container_class' => 'collapse navbar-collapse ', //'collapse navbar-collapse justify-content-end',
                    'menu_id'         => false,
                    'menu_class'      => 'navbar-nav',
                    'depth'           => 3,
                    'fallback_cb'     => 'wp_bootstrap_navwalker::fallback',
                    'walker'          => new wp_bootstrap_navwalker()
                ));
                ?>
            </div>
        </nav>