<?php
/* 

afficher les derniers posts 
éventuellement de catégories choisies

*/
?>

<div class="container px-3 px-md-5 my-5">
    <h2 class="titre-minus font-light text-secondary text-uppercase mb-3">Catégories</h2>
    <div class="row decoration-hover">
        <?php
        // on garde la requete par defaut
        $temp_query = $wp_query;
        // on sélectionne les catégories
        $categories = get_categories();
        
        // on les passe une par une
        foreach($categories as $category) {
            $category_link = get_category_link($category->cat_ID);
            
            // on récupère un post par catgéorie, pour l'image
            $args = array( 
                'post_type'   => 'post',
                'category_name' => $category->slug,
                'posts_per_page' => '1',
                'order_by' => 'DESC',
            );
            query_posts($args); 

            if(have_posts()) : 
            while(have_posts()) : the_post(); ?>
        <div class="col-12 col-sm-6 col-md-4">
            <a href="<?= esc_url( $category_link ); ?>">
            <?php the_post_thumbnail('rectangle', array( 'class' => 'mb-3 w-100' )); ?>
                </a>
            <h2 class="mb-3 titre-petit">
                <a href="<?= esc_url( $category_link ); ?>" title="<?= esc_attr($cat->name); ?>"><?php echo $category->name; ?> (<?php echo $category->count; ?>)</a>
            </h2>
        </div>
        <?php endwhile; ?>
        <?php endif; 


        }
        ?>
    </div>
</div>



<?php
/* retrouver la query de base */
$wp_query = $temp_query; 