<?php 
// stocker la query de base
$temp_query = $wp_query; 

// demander tous les posts
$args = array(
    'post_type' => 'post',
    'order' => 'ASC',
    'posts_per_page' => -1
);
// faire la demande
query_posts($args);
?>

<?php if(have_posts()) : ?>
<div id="mosaique-container" class="container-fluid px-4">

    <!-- barre de filtrage -->
    <div class="form-row form-inline my-3" id="filter-keywords">
        <div class="form-check-label pr-3"><b>Filter : </b></div>
        <?php
        $categories =  get_categories();
        foreach  ($categories as $category) {
            echo '<div class="form-check pe-3">';
            echo '<input type="checkbox" class="form-check-input" value="'.$category->cat_name.'" id="c'.$category->term_id.'" checked>';
            echo '<label class="form-check-label" for="c'.$category->term_id.'">'.$category->cat_name.'</label>';
            echo '</div>';
        }
        ?>
    </div>

    <!-- la mosaique -->
    <div class="row " id="mosaique">
        <?php while(have_posts()) : the_post(); ?>
        <div class="col-3 post mb-4 px-1" id="post-<?php the_ID(); ?>">
            <a href="<?php the_permalink(); ?>"><?php the_post_thumbnail(['class' => 'w-100']); ?></a>
            <h2 class="h6 mt-3"><a class="text-secondary" href="<?php the_permalink(); ?>" title="<?php the_title(); ?>"><?php the_title(); ?></a></h2>
            <div class="categories small">
                <?php the_category(', '); ?>
            </div>
        </div>
        <?php endwhile; ?>
    </div>
</div>

<script>
    // ce code filtre les mots clés sur clic
    jQuery('#filter-keywords input').change(function(){
        // constituer la liste des mots à filtrer
        var liste=[];
        jQuery("#filter-keywords input:checked").each(function(){
            liste.push(jQuery(this).val());
        });

        jQuery("#mosaique .post").each(function(){
            var affiche=false;
            var texte=jQuery(this).find(".categories").html();

            liste.forEach(function(mot){
                if(texte.indexOf(mot) != -1) {
                    affiche=true;
                }  
            });
            if(affiche == true) {
                jQuery(this).fadeIn();
            } else {
                jQuery(this).fadeOut();
            }
        });
    });
</script>
<?php endif; ?>

<?php
// on remet en place la requete initiale
 $wp_query = $temp_query; ?>